function T = dynamic_resid_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_resid_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 110);

T(1) = (params(2)-1)/params(2);
T(2) = (1-params(11))*exp(T(1)*y(44));
T(3) = exp(y(13))^params(3);
T(4) = exp(y(39));
T(5) = T(4)^(1-params(3));
T(6) = T(3)*T(5);
T(7) = T(6)^T(1);
T(8) = exp(y(36));
T(9) = T(2)*T(7)+params(11)*T(8)^T(1);
T(10) = params(2)/(params(2)-1);
T(11) = 1/params(2);
T(12) = exp(y(37))^T(11);
T(13) = (-1)/params(2);
T(14) = T(8)^T(13);
T(15) = T(12)*exp(T(1)*y(44))*(1-params(11))*(1-params(3));
T(16) = T(6)^T(13);
T(17) = T(4)^(-params(3));
T(18) = T(12)*exp(T(1)*y(44))*(1-params(11))*params(3);
T(19) = exp(y(13))^(params(3)-1);
T(20) = exp(y(38));
T(21) = params(9)^((-1)/params(8));
T(22) = 1/params(8);
T(23) = exp(y(40))-params(9)*T(4)^(1+params(8))/(1+params(8));
T(24) = T(23)^(-params(14));
T(25) = exp(y(15))-params(9)*exp(y(14))^(1+params(8))/(1+params(8));
T(26) = T(25)^(-params(14));
T(27) = params(13)^(1-params(4));
T(28) = params(12)^(1-params(4));
T(29) = exp(y(25));
T(30) = T(24)*exp(y(22))*T(29);
T(31) = params(21)^(-1);
T(32) = T(31)*y(18)*(-(exp(y(43))*exp(y(22))*exp(y(11))));
T(33) = exp(y(22))*y(56)+T(32)+T(31)*y(20)*(-(exp(y(22))*exp(y(43))));
T(34) = exp(y(23))/(exp(y(24))+exp(y(23)));
T(35) = exp(y(24))/(exp(y(24))+exp(y(23)));
T(36) = exp(y(22))*T(29)-T(29)*params(6)*exp(y(52)-y(45))^(params(5)-1);
T(37) = T(29)/(exp(y(26))+T(29));
T(38) = exp(y(26))/(exp(y(26))+T(29));
T(39) = params(21)*y(109)*(-(exp(y(27))*exp((-y(97)))*exp(y(31))));
T(40) = exp(y(27))*y(68)+params(21)*y(102)*exp(y(27))*params(6)*exp(params(5)*(y(31)-y(97)))+params(21)*y(105)*(-(exp(y(27))*(1-exp((-y(97)))*exp(y(31)))))+T(39);
T(41) = params(21)*y(108)*(-(exp(y(32))*exp(y(28))));
T(42) = exp(y(28))*y(67)+params(21)*y(102)*params(6)*exp(params(5)*y(32))*exp(y(28))+params(21)*y(104)*(-((1-exp(y(32)))*exp(y(28))))+T(41);
T(43) = exp(y(29))*y(70)+y(68)*(-(params(7)*exp(y(29))))+params(21)*y(107)*(-((1-params(7))*exp(y(29))));
T(44) = exp(y(30))*y(69)+y(67)*(-(params(7)*exp(y(30))))+params(21)*y(106)*(-((1-params(7))*exp(y(30))));
T(45) = params(21)*y(105)*(-(exp(y(27))*(-(exp((-y(97)))*exp(y(31))))));
T(46) = T(39)+params(21)*y(102)*exp(y(27))*params(6)*params(5)*exp(params(5)*(y(31)-y(97)))+T(45);
T(47) = exp(y(95))*params(6)*params(5)*(params(5)-1)*exp(y(32)*(params(5)-1));
T(48) = (-(exp(y(95))*(exp(y(32))*exp(y(87))+y(88)*(-exp(y(32)))-params(6)*params(5)*exp(params(5)*y(32)))));
T(49) = params(21)*y(104)*(-(exp(y(28))*(-exp(y(32)))));
T(50) = T(8)*getPowerDeriv(T(8),T(13),1);
T(51) = T(8)*getPowerDeriv(T(8),T(1),1);
T(52) = getPowerDeriv(T(9),T(10),1);
T(53) = exp(y(37))*getPowerDeriv(exp(y(37)),T(11),1);
T(54) = exp(T(1)*y(44))*(1-params(11))*params(3)*T(53);
T(55) = exp(T(1)*y(44))*(1-params(11))*(1-params(3))*T(53);
T(56) = (1-params(11))*exp(T(1)*y(96));
T(57) = exp(y(92))^(1-params(3));
T(58) = T(20)*getPowerDeriv(T(20),params(3),1);
T(59) = T(20)^params(3);
T(60) = T(57)*T(59);
T(61) = getPowerDeriv(T(60),T(1),1);
T(62) = T(56)*T(57)*T(58)*T(61);
T(63) = T(60)^T(1);
T(64) = T(56)*T(63)+params(11)*exp(y(90))^T(1);
T(65) = getPowerDeriv(T(64),T(10),1);
T(66) = exp(y(92))^(-params(3));
T(67) = exp(y(91))^T(11);
T(68) = T(67)*(1-params(11))*(1-params(3))*exp(T(1)*y(96));
T(69) = T(60)^T(13);
T(70) = getPowerDeriv(T(60),T(13),1);
T(71) = T(57)*T(58)*T(70);
T(72) = T(20)^(params(3)-1);
T(73) = T(67)*(1-params(11))*params(3)*exp(T(1)*y(96));
T(74) = T(20)*getPowerDeriv(T(20),params(3)-1,1);
T(75) = (-(T(57)*(T(72)*T(71)*T(73)+T(69)*T(73)*T(74))));
T(76) = T(4)*getPowerDeriv(T(4),1+params(8),1);
T(77) = (-(params(9)*T(76)/(1+params(8))));
T(78) = getPowerDeriv(T(23),(-params(14)),1);
T(79) = T(77)*T(78);
T(80) = (1-params(3))*exp(y(39)*(1-params(3)));
T(81) = (-(exp(T(1)*y(44))*exp(y(13)*params(3))*T(80)));
T(82) = T(4)*getPowerDeriv(T(4),1-params(3),1);
T(83) = getPowerDeriv(T(6),T(13),1);
T(84) = T(3)*T(82)*T(83);
T(85) = (-(T(16)*T(18)*T(19)*T(82)+T(5)*T(19)*T(18)*T(84)));
T(86) = T(4)*getPowerDeriv(T(4),(-params(3)),1);
T(87) = (-(T(17)*T(3)*T(15)*T(84)+T(3)*T(15)*T(16)*T(86)));
T(88) = getPowerDeriv(T(6),T(1),1);
T(89) = T(2)*T(3)*T(82)*T(88);
T(90) = exp(y(93))-params(9)*exp(y(92))^(1+params(8))/(1+params(8));
T(91) = params(1)*T(90)^(-params(14));
T(92) = exp(y(40))*T(78);
T(93) = (-(params(1)*T(92)/T(26)));
T(94) = T(31)*y(17)*(-(exp(y(41))*exp(y(43))));
T(95) = exp(y(42))*getPowerDeriv(exp(y(42)),T(22),1);
T(96) = T(31)*y(20)*(exp(y(43))*params(6)*params(5)*exp(y(11)*(params(5)-1))-exp(y(43))*(exp(y(22))-y(34)))+exp(y(43))*y(62)+T(31)*y(17)*(-(exp(y(43))*(1+exp(y(41))-params(10))))+T(31)*y(18)*(-(exp(y(43))*(exp(y(22))*exp(y(11))+y(34)*(1-exp(y(11)))-params(6)*exp(params(5)*y(11)))))+T(31)*y(19)*(-(y(35)*exp(y(43))*(1-params(7))));
T(97) = T(12)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(44));
T(98) = T(12)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(44));
T(99) = (1-params(11))*T(1)*exp(T(1)*y(44));
T(100) = T(7)*T(99);
T(101) = params(21)^2;
T(102) = getPowerDeriv(exp(y(52)-y(45)),params(5)-1,1);
T(103) = (-(T(29)*params(6)*(-exp(y(52)-y(45)))*T(102)));
T(104) = T(24)*T(103);
T(105) = (-(exp(y(6))*exp(y(10))*(-exp((-y(45))))));
T(106) = (-(exp(y(6))*(-(exp(y(10))*(-exp((-y(45))))))));
T(107) = exp(y(6))*params(6)*exp(params(5)*(y(10)-y(45)))*(-params(5));
T(108) = y(72)*T(105)+y(68)*T(106)+y(60)*T(107);
T(109) = (-(T(29)*params(6)*exp(y(52)-y(45))*T(102)));
T(110) = exp(y(95))*params(6)*params(5)*exp(y(32)*(params(5)-1))-exp(y(95))*(exp(y(87))-y(88));

end
